unit EvalRes;

interface

const
     ConstCompare = 'First strint|Second string';
     ConstText    = 'Text';
     ConstDate    = 'Date';
     ConstTime    = 'Time';
     ConstNumber  = 'Number';
     ConstFileName= 'File name';


resourcestring

   rsAnd                = 'And';
   rsOr                 = 'Or';
   rsNotAnd             = 'not And';
   rsNotOr              = 'not Or';
   rsNot                = 'not';

   rsTrue               = 'True';
   rsFalse              = 'False';

   // Listboxes &ComboBoxes
   rsHistoryCaption     = 'Save expression/condition';
   rsHistoryPrompt      = 'Expression/Condition';

   rsHTMLCaption        = 'List of functions supporting library EVAL.';

   // Function's group names
   rsGroupAll           = 'All functions';
   rsGroupOperators     = 'Operators';
   rsGroupString        = 'Text functions';
   rsGroupDate          = 'Date & Time';
   rsGroupNumber        = 'Numeric functions';
   rsGroupGonio         = 'Goniometric & Geometric';
   rsGroupFinancial     = 'Financial functions';
   rsGroupConversion    = 'Converter functions';
   rsGroupFile          = 'Functions with files';
   rsGroupMisc          = 'Different functions';

   //
   rsFunctionLabel      = 'Function';
   rsFunctionGroupLabel = 'Group of functions';
   rsSubFunctionHint    = 'Nested function';
   rsSubFunctionCaption = 'Nested function';

   // Eval engine errors
   rsErrorInPosition    = 'Error in position %d  : %s';
   rsEvalStackOverflow  = 'Eval Stack overflow';
   rsEvalStackUnderflow = 'Eval Stack underflow';
   rsConditionWithoutEnd= 'Expression without end ...';
   rsErrorInCondition   = 'Error in condition ...';  
   rsOpConstNotFound    = 'Expected identifier or constant.';
   rsCharNotFound       = 'Expected '' %s  ''';
   rsUnknownID          = 'Unknown identifier "%s"';
   rsDuplVar            = 'Duplicate variable "%s"';
   rsVarNotFound        = 'Variable "%s" absent.';
   rsPostFixError       = 'EvalPostFix error : FStack.Top = %d';
   rsUnknownSymbol      = 'Unknown symbol in PostFixList';
   rsLeftNotFound       = 'Missing left parenthesis.';
   rsRightNotFound      = 'Missing right parenthesis.';
   rsColonNotFound      = 'Missing colon.';
   rsCommaNotFound      = 'Missing comma.';

   // Eval functions arguments & labels
   rsExpressionErrorCreate = 'Error in expression';
   rsFunArrayError         = 'Too many functions';



   // functions hints
   rsConst6Arg    = 'Argument1|Argument2|Argument3|Argument4|Argument5|Argument6';
   rsConst2Arg    = 'Argument1|Argument2';

   rsHint_STRING                   = 'Conversion to string';
   rsHint_INTEGER                  = 'Conversion to integer';
   rsHint_Boolean                  = 'Conversion to boolean';
   rsHint_Real                     = 'Conversion to real number';


   rsHint_Plus         = 'Plus, counting the arguments (number or text)';
   rsHint_Minus        = 'Minus';
   rsHint_Multiply     = 'Multiplication';
   rsHint_Division     = 'Dividing';
   rsHint_And          = 'Logical and operation, valid if valid all arguments';
   rsHint_Or           = 'Logical or operation, valid if valid at least one argument';
   rsHint_XOR          = 'Logical xor operation , valid if all arguments are different';
   rsHint_Above        = 'Major than';
   rsHint_AboveEqual   = 'Major or straight than';
   rsHint_Less         = 'Less than';
   rsHint_LessEqual    = 'Less or straight than';
   rsHint_Equal        = 'Straight';
   rsHint_NotEqual     = 'Various';
   rsHint_Not          = 'No (logick negcia)';
   rsHint_MOD          = 'A residual after dividing';
   rsHint_DIV          = 'Integral dividing';


   rsHint_Contain                  = 'Test, if first string occur in second string.';
   rsHint_AnsiCompareStr           = 'AnsiCompareStr compares strings based on the current Windows locale and is case sensitive.';
   rsHint_AnsiCompareText          = 'AnsiCompareText compares strings based on the current Windows locale and is not case sensitive.';
   rsHint_Concat                   = 'Concat concatenates two or more strings into one.';
   rsHint_Copy                     = 'Copy returns a substring of a string.';
   rsHint_Delete                   = 'Delete removes a substring from a s string.';
   rsHint_Insert                   = 'Insert inserts a substring into a string beginning at a specified point.';
   rsHint_Replace                  = 'Replace searches for specific text and replaces it with new text.';
   rsHint_Length                   = 'Length returns the number of characters used in a string.';
   rsHint_Pos                      = 'Pos returns the index value of the first character in a specified substring that occurs in a given string.';
   rsHint_StringOfChar             = 'StringOfChar returns a string with the specified number of characters.';
   rsHint_LowerCase                = 'LowerCase converts an ASCII string to lowercase.';
   rsHint_UpperCase                = 'UpperCase returns a string in uppercase.';
   rsHint_AnsiLowerCase            = 'AnsiLowerCase converts the given string to lower case.';
   rsHint_AnsiUpperCase            = 'AnsiLowerCase converts the given string to upper case.';
   rsHint_Trim                     = 'Trim trims a string of leading and trailing spaces and control characters.';
   rsHint_TrimLeft                 = 'TrimLeft trims string of leading spaces and control characters.';
   rsHint_TrimRight                = 'TrimRight trims string of trailing spaces and control characters.';
   rsHint_PosWithError             = 'Search a text in the another text with mistakes and faults';
   rsHint_StringAnywhere           = 'Search a text in all fields of the table';
   rsHint_AnsiStringAnywhere       = 'Search a text in all fields of the table also with diacritical';
   rsHint_CompareStr               = 'CompareStr compares strings case sensitively.';
   rsHint_CompareText              = 'CompareText compares strings by ordinal value and is not case sensitive.';
   rsHint_QuotedStr                = 'QuotedStr returns the quoted version of a string.';
   rsHint_AnsiQuotedStr            = 'AnsiQuotedStr returns the quoted version of a string.';
   rsHint_AnsiExtractQuotedStr     = 'AnsiExtractQuotedStr converts a quoted string into an unquoted string.';
   rsHint_AnsiPos                  = 'AnsiPos locates the position of a substring within a string.';
   rsHint_Before                   = 'Returns the text situated in front of specific note.';
   rsHint_After                    = 'Returns the text situated behind specific note.';
   rsHint_Left                     = 'Returns the text in a definite length left.';
   rsHint_Right                    = 'Returns the text in a definite length forward.';
   rsHint_Chr                      = 'Chr returns the character for a specified ASCII value.';
   rsHint_Ord                      = 'Ord returns the ordinal value of an ordinal-type expression.';
   rsHint_DelChars                 = 'Delete definite expressions from the text.';
   rsHint_Center                   = 'Centring the text for definite number of chars.';
   rsHint_MatchStrings             = 'Compares a texts with using ? a *';
   rsHint_WordCount                = 'Counting, how many words contains the text.';
   rsHint_GetWord                  = 'Returns the word according to definite order.';
   rsHint_CapFirst                 = 'Changes the first letter of everyone word to uppercase, and the rest to lowercase.';
   rsHint_SoundLike                = 'Compares, if is same in english the sounds of two words.';


  // date functions
   rsHint_Date                     = 'Date gets the current date.';
   rsHint_DayOfWeek                = 'DayOfWeek returns the day of the week for a specified date.';
   rsHint_EncodeDate               = 'EncodeDate returns a TDateTime type for a specified Year, Month, and Day.';
   rsHint_EncodeTime               = 'EncodeTime returns a TDateTime type for a specified Hour, Min, Sec, and MSec.';
   rsHint_FormatDateTime           = 'FormatDateTime formats a date-and-time value.';
   rsHint_Year                     = 'Year returns a Year for a specified DateTime';
   rsHint_Month                    = 'Month returns a Month for a specified DateTime';
   rsHint_Day                      = 'Day returns a Day for a specified DateTime';
   rsHint_Week                     = 'Week returns a Week number from beginning of the Year for a specified DateTime';
   rsHint_Century                  = 'Century returns a century for a specified DateTime';
   rsHint_MonthName                = 'Returns a month in roman type for a specified date';
   rsHint_MonthNameLong            = 'Returns full name of the month for a specified date';
   rsHint_DayName                  = 'Returns short name of the day for a specified date';
   rsHint_DayNameLong              = 'Returns full name of the day for a specified date';
   rsHint_Time                     = 'Time returns the current time.';
   rsHint_Now                      = 'Now returns the current date and time.';
   rsHint_IncMonth                 = 'IncMonth returns a date shifted by a specified number of months.';
   rsHint_IncDays                  = 'IncMonth returns a date shifted by a specified number of days.';
   rsHint_IsLeapYear               = 'IsLeapYear indicates whether a specified year is a leap year.';
   rsHint_DaysInMonth              = 'Returns number of the days in the month by a specified date.';
   rsHint_DaysBetween              = 'Returns number of a days between two dates.';
   rsHint_Hour                     = 'Returns a hour (00-23)  for a specified time.';
   rsHint_Minute                   = 'Returns a minuts (00-59) for a specified time.';
   rsHint_Second                   = 'Returns a seconds (00-59) for a specified time.';

   // file functions
   rsHint_ChangeFileExt            = 'ChangeFileExt changes the file extension.';
   rsHint_ExpandFileName           = 'ExpandFileName returns the full path of Filename.';
   rsHint_ExtractFileDir           = 'ExtractFileDir extracts the drive and directory parts from FileName. ';
   rsHint_ExtractFileExt           = 'ExtractFileExt returns the extension portions of FileName.';
   rsHint_ExtractFileName          = 'ExtractFileName extracts the name and extension parts of FileName. ';
   rsHint_ExtractFilePath          = 'ExtractFilePath returns the drive and directory portions of FileName. ';
   rsHint_ExtractFileDrive         = 'ExtractFileDrive returns the drive portion from FileName.';
   rsHint_ExpandUNCFileName        = 'ExpandUNCFileName returns the full path of FileName with the network drive portion in UNC format.';
   rsHint_ExtractRelativePath      = 'ExtractRelativePath returns a relative path name, relative to a specific base directory.';
   rsHint_FileAge                  = 'FileAge returns the date-and-time stamp of the specified file.';
   rsHint_FileExists               = 'FileExists tests if FileName exists.';
   rsHint_FileSize                 = 'FileSize returns the size of a file in bytes or the number of records in a record file.';
   rsHint_FileSearch               = 'FileSearch searchs a specified DOS path for a file.';
   rsHint_DiskFree                 = 'DiskFree returns the number of free bytes on a specified drive. ';
   rsHint_DiskSize                 = 'DiskSize returns the size, in bytes, of the specified drive.';
   rsHint_AnsiCompareFileName      = 'AnsiCompareFileName compares file names based on the current locale.';
   rsHint_AnsiLowerCaseFileName    = 'AnsiLowerCaseFileName converts a file name to lower case.';
   rsHint_AnsiUpperCaseFileName    = 'AnsiUpperCaseFileName converts a file name to upper case.';

    // numeric
   rsHint_Abs                      = 'Abs returns an absolute value. ';
   rsHint_Frac                     = 'Frac returns the fractional part of a real number.';
   rsHint_Trunc                    = 'Trunc truncates a real number to an integer.';
   rsHint_Round                    = 'Round returns the value of X rounded to the nearest whole number.';
   rsHint_Hi                       = 'Hi returns the high-order byte of X as an unsigned value.';
   rsHint_Int                      = 'Int returns the integer part of a real number.';
   rsHint_Ln                       = 'Ln returns the natural log of a real expression.';
   rsHint_Lo                       = 'Lo returns the low order Byte of argument X.';
   rsHint_Odd                      = 'Odd returns True if argument is an odd number.';
   rsHint_Random                   = 'Random generates random numbers within a specified range.';
   rsHint_Sqr                      = 'Sqr returns X squared';
   rsHint_Sqrt                     = 'Sqrt returns the square root of X.';
   rsHint_Min                      = 'Min returns a minimum value of arguments';
   rsHint_Max                      = 'Max returns a maximum value of arguments';
   rsHint_Exp                      = 'Exp returns the exponential of X.';
   rsHint_PI                       = 'Pi returns 3.1415926535897932385. ';
   rsHint_LNXP1                    = 'LnXP1 returns the natural log of (X+1)';
   rsHint_Log10                    = 'Log10 calculates log base 10.';
   rsHint_Log2                     = 'Log2 calculates log base 2.';
   rsHint_LogN                     = 'LogN calculates log base N.';
   rsHint_IntPower                 = 'IntPower calculates Base to the power of Exponent.';
   rsHint_Power                    = 'Power raises Base to any power.';
   rsHint_Mantissa                 = 'Mantissa separates the Mantissa of X';
   rsHint_Exponent                 = 'Exponent separates the Exponents of X';
   rsHint_LDExp                    = 'Ldexp calculates X * (2P)';
   rsHint_Ceil                     = 'Ceil rounds variables up.';
   rsHint_Floor                    = 'Floor rounds variables down.';
   rsHint_Sign                     = 'if X>0 returns 1, if X=0 return 0, else returns -1.';
   rsHint_Faktorial                = 'Returns N*(N-1)*(N-2)* ...*2*1';
   rsHint_Permutation              = 'Returns number of combinations of N over K.';

   // goniometric
   rsHint_Sin                      = 'Sin returns the sine of the angle in radians.';
   rsHint_Cos                      = 'Cos calculates the cosine of an angle.';
   rsHint_Tan                      = 'Tan returns the tangent of X.';
   rsHint_CoTan                    = 'Cotan calculates the cotangent of an angle.';
   rsHint_ArcSin                   = 'ArcSin calculates the inverse sine of the given number.';
   rsHint_ArcCos                   = 'ArcCos calculates the inverse cosine of the given number.';
   rsHint_ArcTan                   = 'ArcTan calculates the arctangent of the given number.';
   rsHint_ArcTan2                  = 'ArcTan2 calculates the arctangent angle and quadrant of the given number.';
   rsHint_Hypot                    = 'Hypot calculates the length of the hypotenuse.';
   rsHint_DegToRad                 = 'DegToRad returns the value of a degree measurement expressed in radians.';
   rsHint_RadToDeg                 = 'RadToDeg converts radians to degrees.';
   rsHint_GradToRad                = 'GradToRad converts grad measurements to radians.';
   rsHint_RadToGrad                = 'RadToGrad converts radians to grads.';
   rsHint_CycleToRad               = 'CycleToRad converts an angle measurement from cycles to radians.';
   rsHint_RadToCycle               = 'RadToCycle converts radians to cycles.';
   rsHint_Cosh                     = 'Cosh calculates the hyperbolic cosine of an angle.';
   rsHint_Sinh                     = 'Sinh returns the hyperbolic sine of an angle.';
   rsHint_TanH                     = 'Tanh returns the hyperbolic tangent of X.';
   rsHint_ArcCosh                  = 'ArcCosh calculates the inverse hyperbolic cosine of the given number.';
   rsHint_ArcSinh                  = 'ArcSinh calculates the inverse hyperbolic sine of the given number.';
   rsHint_ArcTanH                  = 'ArcTanh calculates the inverse hyperbolic tangent of the given number.';
   rsHint_CircleO                  = 'Returns circumference of a circle.';
   rsHint_CircleP                  = 'Returns content of a circle.';

   // conversion
   rsHint_NumberToSpell            = 'Transfers whole number in to the texts form.';
   rsHint_DateTimeToStr            = 'DateTimeToStr converts a variable of type TDateTime to a string.';
   rsHint_DateTimeToString         = 'DateTimeToString converts a variable to a string using the specified Format.';
   rsHint_DateToStr                = 'DateToStr converts a variable of type TDateTime to a formatted string. ';
   rsHint_FloatToStr               = 'FloatToStr converts a floating point value to a string.';
   rsHint_CurrToStr                = 'CurrToStr converts a currency variable to a string.';
   rsHint_FormatFloat              = 'FormatFloat formats a floating point value.';
   rsHint_IntToHex                 = 'IntToHex returns the hex representation of an integer.';
   rsHint_StrToDate                = 'StrToDate converts a string to a date format. ';
   rsHint_StrToDateTime            = 'StrToDateTime converts a string into TDateTime format. ';
   rsHint_StrToFloat               = 'StrToFloat converts given string to a floating-point value. ';
   rsHint_StrToCurr                = 'StrToCurr converts a floating point number to a currency value. ';
   rsHint_StrToInt                 = 'StrToInt converts a string representing an integer (decimal or hex notation) to a number.';
   rsHint_StrToTime                = 'StrToTime converts a string to a time value.';
   rsHint_IntToStr                 = 'IntToStr converts an integer to a string.';
   rsHint_FloatToDecimal           = 'FloatToDecimal converts a floating-point value to a decimal representation.';
   rsHint_FloatToStrF              = 'FloatToStrF converts a floating point value to a string, using a specified Format, Precision, and Digits. ';
   rsHint_CurrToStrF               = 'CurrToStrF converts a currency variable to a string of a specified format. ';
   rsHint_FormatCurr               = 'FormatCurr formats a currency value. ';
   rsHint_TimeToStr                = 'TimeToStr returns a string from a TDateTime variable.';
   rsHint_DecToRoman               = 'Converts integer value to Roman representation.';

   // miscelanous
   rsHint_Cond                     = 'Conditional expression - if condition is valid(first parameter), the the result is second parameter, if not, the result is third parameter.';
   rsHint_Between                  = 'Accelerated test, if the number is between two values.';
   rsHint_BetweenStrings           = 'Accelerated test, if the string is between two values.';
   rsHint_SysErrorMessage          = 'SysErrorMessage converts Win32 API error codes into strings.';
   rsHint_GetLocaleStr             = 'Returns string to local settings of Windows.';

   // financial functions
   rsHint_DoubleDecliningBalance   = 'DoubleDecliningBalance calculates the depreciation of an asset using the double-declining balance method.';
   rsHint_FutureValue              = 'FutureValue calculates the future value of an investment.';
   rsHint_InterestPayment          = 'InterestPayment calculates the interest portion of a loan payment.';
   rsHint_InterestRate             = 'InterestRate returns the interest rate required to increase PresentValue to FutureValue.';
   rsHint_NumberOfPeriods          = 'NumberOfPeriods returns the number of payment periods for an investment.';
   rsHint_NetPresentValue          = 'NetPresentValue calculates the current value from an array of estimated cash flow values. ';
   rsHint_Payment                  = 'Payment calculates a fully amortized payment.';
   rsHint_PeriodPayment            = 'PeriodPayment returns the principal amount from a full payment.';
   rsHint_PresentValue             = 'PresentValue calculates the present value of an investment.';
   rsHint_SLNDepreciation          = 'SLNDepreciation returns the straight-line depreciation allowance of an asset.';
   rsHint_SYDDepreciation          = 'SYDDepreciation calculates depreciation for an asset.';



   // label for multiple use

   // functions parameters label
   rsPar_MOD                      = 'Dividend|Divisor';
   rsPar_DIV                      = 'Dividend|Divisor';
   rsPar_STRING                   = 'Value';
   rsPar_INTEGER                  = 'Value';
   rsPar_Boolean                  = 'Value';
   rsPar_Real                     = 'Value';

   rsPar_NOT                      = 'Expression';

   rsPar_AnsiCompareStr           = ConstCompare;
   rsPar_AnsiCompareText          = ConstCompare;
   rsPar_Concat                   = 'First string|Second string|Third string';
   rsPar_Copy                     = 'Text|From position|Number of characters';
   rsPar_Delete                   = 'Text|From position|Number of characters';
   rsPar_Insert                   = 'Text|To position|Inserted text';
   rsPar_Replace                  = 'What|Where|By';
   rsPar_Length                   = constText;
   rsPar_Pos                      = 'Search text|Text';
   rsPar_StringOfChar             = 'String|Repeat count';
   rsPar_LowerCase                = constText;
   rsPar_UpperCase                = constText;
   rsPar_AnsiLowerCase            = constText;
   rsPar_AnsiUpperCase            = constText;
   rsPar_Trim                     = constText;
   rsPar_TrimLeft                 = constText;
   rsPar_TrimRight                = constText;
   rsPar_PosWithError             = 'Search string|String|Errors';
   rsPar_StringAnywhere           = constText;
   rsPar_AnsiStringAnywhere       = constText;
   rsPar_CompareStr               = constCompare;
   rsPar_CompareText              = constCompare;
   rsPar_QuotedStr                = constText;
   rsPar_AnsiQuotedStr            = 'String|Quotation mark';
   rsPar_AnsiExtractQuotedStr     = 'String|Quotation mark';
   rsPar_AnsiPos                  = 'Search string|Where';
   rsPar_Before                   = 'String|Separator';
   rsPar_After                    = 'String|Separator';
   rsPar_Left                     = 'String|Number of characters';
   rsPar_Right                    = 'String|Number of characters';
   rsPar_Chr                      = 'Number';
   rsPar_Ord                      = 'String';
   rsPar_DelChars                 = 'String|Deleted chars';
   rsPar_Center                   = 'String|Number of characters|Filling char';
   rsPar_MatchStrings             = 'Text 1|Text 2';
   rsPar_WordCount                = 'Text';
   rsPar_GetWord                  = 'Text|Word number';
   rsPar_CapFirst                 = 'Text';
   rsPar_SoundLike                = 'Text 1|Text 2';

   // date functions
   rsPar_Date                     = '';
   rsPar_DayOfWeek                = ConstDate;
   rsPar_EncodeDate               = 'Year|Month|Day';
   rsPar_EncodeTime               = 'Hours|Minutes|Seconds|Miliseconds';
   rsPar_FormatDateTime           = 'Date & Time|Format string';
   rsPar_Year                     = ConstDate;
   rsPar_Month                    = ConstDate;
   rsPar_Day                      = ConstDate;
   rsPar_Week                     = ConstDate;
   rsPar_Century                  = ConstDate;
   rsPar_MonthName                = ConstDate;
   rsPar_MonthNameLong            = ConstDate;
   rsPar_DayName                  = ConstDate;
   rsPar_DayNameLong              = ConstDate;
   rsPar_Time                     = '';
   rsPar_Now                      = '';
   rsPar_IncMonth                 = 'Date|Months';
   rsPar_IncDays                  = 'Date|Days';
   rsPar_IsLeapYear               = ConstDate;
   rsPar_DaysInMonth              = ConstDate;
   rsPar_DaysBetween              = 'First date|Second date';
   rsPar_Hour                     = ConstTime;
   rsPar_Minute                   = ConstTime;
   rsPar_Second                   = ConstTime;

   // file functions
   rsPar_ChangeFileExt            = 'Filename|New extension';
   rsPar_ExpandFileName           = ConstFileName;
   rsPar_ExtractFileDir           = ConstFileName;
   rsPar_ExtractFileExt           = ConstFileName;
   rsPar_ExtractFileName          = ConstFileName;
   rsPar_ExtractFilePath          = ConstFileName;
   rsPar_ExtractFileDrive         = ConstFileName;
   rsPar_ExpandUNCFileName        = ConstFileName;
   rsPar_ExtractRelativePath      = 'Filename|Base directory';
   rsPar_FileAge                  = ConstFileName;
   rsPar_FileExists               = ConstFileName;
   rsPar_FileSize                 = ConstFileName;
   rsPar_FileSearch               = 'Filename|List of directories';
   rsPar_DiskFree                 = 'Drive';
   rsPar_DiskSize                 = 'Drive';
   rsPar_AnsiCompareFileName      = 'Text 1|Text 2';
   rsPar_AnsiLowerCaseFileName    = ConstFileName;
   rsPar_AnsiUpperCaseFileName    = ConstFileName;

    // numeric
   rsPar_Abs                      = ConstNumber ;
   rsPar_Frac                     = ConstNumber ;
   rsPar_Trunc                    = ConstNumber ;
   rsPar_Round                    = ConstNumber ;
   rsPar_Hi                       = ConstNumber ;
   rsPar_Int                      = ConstNumber ;
   rsPar_Ln                       = ConstNumber ;
   rsPar_Lo                       = ConstNumber ;
   rsPar_Odd                      = ConstNumber ;
   rsPar_Random                   = ConstNumber ;
   rsPar_Sqr                      = ConstNumber ;
   rsPar_Sqrt                     = ConstNumber ;
   rsPar_Min                      = 'First number|Second number';
   rsPar_Max                      = 'First number|Second number';
   rsPar_Exp                      = ConstNumber ;
   rsPar_PI                       = '';
   rsPar_LNXP1                    = ConstNumber ;
   rsPar_Log10                    = ConstNumber ;
   rsPar_Log2                     = ConstNumber ;
   rsPar_LogN                     = 'Base|Argument';

   rsPar_IntPower                 = 'Base|Exponent';
   rsPar_Power                    = 'Base|Exponent';
   rsPar_Mantissa                 = ConstNumber;
   rsPar_Exponent                 = ConstNumber;
   rsPar_LDExp                    = 'X|P';
   rsPar_Ceil                     = ConstNumber;
   rsPar_Floor                    = ConstNumber;
   rsPar_Sign                     = ConstNumber;
   rsPar_Faktorial                = ConstNumber;
   rsPar_Permutation              = 'N|K';

   // goniometric
   rsPar_Sin                      = 'Argument in radians';
   rsPar_Cos                      = 'Argument in radians';
   rsPar_Tan                      = 'Argument in radians';
   rsPar_CoTan                    = 'Argument in radians';
   rsPar_ArcSin                   = 'Argument';
   rsPar_ArcCos                   = 'Argument';
   rsPar_ArcTan                   = 'Argument';
   rsPar_ArcTan2                  = 'Y|X';
   rsPar_Hypot                    = 'X|Y';
   rsPar_DegToRad                 = 'Degrees';
   rsPar_RadToDeg                 = 'Radians';
   rsPar_GradToRad                = 'Argument';
   rsPar_RadToGrad                = 'Radians';
   rsPar_CycleToRad               = 'Argument';
   rsPar_RadToCycle               = 'Radians';
   rsPar_Cosh                     = 'Argument';
   rsPar_Sinh                     = 'Argument';
   rsPar_TanH                     = 'Argument';
   rsPar_ArcCosh                  = 'Argument';
   rsPar_ArcSinh                  = 'Argument';
   rsPar_ArcTanH                  = 'Argument';
   rsPar_CircleO                  = 'Radius';
   rsPar_CircleP                  = 'Radius';

   // conversion
   rsPar_NumberToSpell            = 'Integer';
   rsPar_DateTimeToStr            = 'Date & Time';
   rsPar_DateTimeToString         = 'Date & Time|Format string';
   rsPar_DateToStr                = 'Date & Time';
   rsPar_FloatToStr               = 'Real number';
   rsPar_CurrToStr                = 'Money';
   rsPar_FormatFloat              = 'Real number|Format string';
   rsPar_IntToHex                 = 'Integer|Digits';
   rsPar_StrToDate                = 'Text';
   rsPar_StrToDateTime            = 'Text';
   rsPar_StrToFloat               = 'Text';
   rsPar_StrToCurr                = 'Text';
   rsPar_StrToInt                 = 'Text';
   rsPar_StrToTime                = 'Text';
   rsPar_IntToStr                 = 'Integer';
   rsPar_FloatToDecimal           = 'Real number';
   rsPar_FloatToStrF              = 'Real number|Format string|Precision|Digits';
   rsPar_CurrToStrF               = 'Money|Format string|Digits';
   rsPar_FormatCurr               = 'Money|Format string';
   rsPar_TimeToStr                = 'Time';
   rsPar_DecToRoman               = 'Integer';

   // miscelanous
   rsPar_Cond                     = 'Condition|Expr. if True|Expr. if False';
   rsPar_Between                  = 'Value|Low bound|High bound';
   rsPar_BetweenStrings           = 'Value|Low bound|High bound';
   rsPar_SysErrorMessage          = 'System erroe number';
   rsPar_GetLocaleStr             = 'Locale|Locale type';

   // financial functions
   rsPar_DoubleDecliningBalance   = 'Cost|Salvage|Life|Period';
   rsPar_FutureValue              = 'Rate|NPeriods|Payment|PresentValue|PaymentTime';
   rsPar_InterestPayment          = 'Rate|Period|NPeriods|PresentValue|FutureValue|PaymentTime';
   rsPar_InterestRate             = 'NPeriods|Payment|PresentValue|FutureValue|PaymentTime';
   rsPar_NumberOfPeriods          = 'Rate|Payment|PresentValue|FutureValue|PaymentTime';
   //rsPar_NetPresentValue          = 'Rate|NPeriods|PresentValue|FutureValue|PaymentTime';
   rsPar_Payment                  = 'Rate|NPeriods|PresentValue|FutureValue|PaymentTime';
   rsPar_PeriodPayment            = 'Rate|Period|NPeriods|PresentValue|FutureValue|PaymentTime';
   rsPar_PresentValue             = 'Rate|NPeriods|Payment|FutureValue|PaymentTime';
   rsPar_SLNDepreciation          = 'Cost|Salvage|Life';
   rsPar_SYDDepreciation          = 'Cost|Salvage|Life|Period';


implementation

end.
